<?php
function json_response($data, int $code=200) {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data, JSON_UNESCAPED_UNICODE);
  exit;
}

function redirect($url) {
  header('Location: ' . $url);
  exit;
}

function h($str) {
  return htmlspecialchars((string)$str, ENT_QUOTES, 'UTF-8');
}

function base_url() {
  $config = require __DIR__ . '/config.php';
  $b = trim($config['base_url']);
  if ($b !== '') return rtrim($b, '/');
  // auto-detect
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  return $scheme . '://' . $host;
}

function csrf_token() {
  if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(16));
  }
  return $_SESSION['csrf'];
}

function csrf_validate($token) {
  return isset($_SESSION['csrf']) && hash_equals($_SESSION['csrf'], (string)$token);
}
