<?php
require __DIR__ . '/_header.php';

$eventWhere = !empty($u['event_id']) ? " WHERE g.event_id=" . (int)$u['event_id'] . " " : "";
$q = trim($_GET['q'] ?? '');
$filter = $_GET['filter'] ?? 'all';

$where = [];
$params = [];
if (!empty($u['event_id'])) {
  $where[] = "g.event_id = ?";
  $params[] = (int)$u['event_id'];
}
if ($q !== '') {
  $where[] = "(g.name LIKE ? OR g.code LIKE ?)";
  $params[] = "%$q%";
  $params[] = "%$q%";
}
if ($filter === 'not_checkedin') $where[] = "gs.checked_in_at IS NULL";
if ($filter === 'checkedin') $where[] = "gs.checked_in_at IS NOT NULL";
if ($filter === 'souvenir') $where[] = "gs.souvenir_at IS NOT NULL";

$whereSql = $where ? ("WHERE " . implode(" AND ", $where)) : "";
$stmt = $db->prepare("SELECT g.id, g.name, g.code, gs.checked_in_at, gs.souvenir_at
                      FROM guests g JOIN guest_status gs ON gs.guest_id=g.id
                      $whereSql
                      ORDER BY g.id DESC
                      LIMIT 500");
$stmt->execute($params);
$rows = $stmt->fetchAll();
?>
<div class="card shadow-sm">
  <div class="card-body">
    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2">
      <h1 class="h5 mb-0">Daftar Tamu</h1>
      <div class="d-flex gap-2">
        <a class="btn btn-outline-secondary btn-sm" href="/admin/export.php">Export CSV</a>
      </div>
    </div>

    <form class="row g-2 mt-2">
      <div class="col-12 col-md-6">
        <input class="form-control" name="q" value="<?= h($q) ?>" placeholder="Cari nama / code">
      </div>
      <div class="col-8 col-md-4">
        <select class="form-select" name="filter">
          <option value="all" <?= $filter==='all'?'selected':'' ?>>Semua</option>
          <option value="not_checkedin" <?= $filter==='not_checkedin'?'selected':'' ?>>Belum check-in</option>
          <option value="checkedin" <?= $filter==='checkedin'?'selected':'' ?>>Sudah check-in</option>
          <option value="souvenir" <?= $filter==='souvenir'?'selected':'' ?>>Sudah souvenir</option>
        </select>
      </div>
      <div class="col-4 col-md-2 d-grid">
        <button class="btn btn-primary">Filter</button>
      </div>
    </form>

    <div class="table-responsive mt-3">
      <table class="table table-sm align-middle">
        <thead>
          <tr>
            <th>#</th>
            <th>Nama</th>
            <th>CODE</th>
            <th>Check-in</th>
            <th>Souvenir</th>
            <th>Link QR</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= h($r['id']) ?></td>
            <td class="fw-semibold"><?= h($r['name']) ?></td>
            <td><code><?= h($r['code']) ?></code></td>
            <td><?= $r['checked_in_at'] ? '<span class="badge text-bg-success">OK</span><div class="small text-secondary">'.h($r['checked_in_at']).'</div>' : '<span class="badge text-bg-secondary">NO</span>' ?></td>
            <td><?= $r['souvenir_at'] ? '<span class="badge text-bg-success">OK</span><div class="small text-secondary">'.h($r['souvenir_at']).'</div>' : '<span class="badge text-bg-secondary">NO</span>' ?></td>
            <td><a target="_blank" href="/public/qr.php?code=<?= h($r['code']) ?>">Buka</a></td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <div class="small text-secondary">Menampilkan maksimal 500 data.</div>
  </div>
</div>
<?php require __DIR__ . '/_footer.php'; ?>
