<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/auth.php';
require_login();
$u = current_user();

$where = [];
$params = [];
if (!empty($u['event_id'])) {
  $where[] = "g.event_id = ?";
  $params[] = (int)$u['event_id'];
}
$whereSql = $where ? ("WHERE " . implode(" AND ", $where)) : "";

$stmt = $db->prepare("SELECT g.name, g.code, gs.checked_in_at, gs.souvenir_at
                      FROM guests g JOIN guest_status gs ON gs.guest_id=g.id
                      $whereSql
                      ORDER BY g.id ASC");
$stmt->execute($params);
$rows = $stmt->fetchAll();

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="guests_export.csv"');

$out = fopen('php://output', 'w');
fputcsv($out, ['name','code','checked_in_at','souvenir_at']);
foreach ($rows as $r) {
  fputcsv($out, [$r['name'], $r['code'], $r['checked_in_at'], $r['souvenir_at']]);
}
fclose($out);
exit;
